/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroEntityReference;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroEntityReference
extends AbstractMicroNode
implements IMicroEntityReference {
    private final String m_sName;

    public MicroEntityReference(@Nonnull @Nonempty String sName) {
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("The passed entity reference name is invalid");
        }
        this.m_sName = sName;
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.ENTITY_REFERENCE;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return '&' + this.m_sName + ';';
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeValue() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public IMicroEntityReference getClone() {
        return new MicroEntityReference(this.m_sName);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicroEntityReference)) {
            return false;
        }
        MicroEntityReference rhs = (MicroEntityReference)o;
        return this.m_sName.equals(rhs.m_sName);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("name", this.m_sName).toString();
    }
}

