/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.resource;

import com.phloc.commons.annotations.DevelopersNote;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.text.resource.XMLResourceBundleControl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class XMLResourceBundle
extends ResourceBundle {
    private final Map<String, String> m_aValues = new HashMap<String, String>();

    @DevelopersNote(value="Don't use it manually - use the static methods of this class!")
    XMLResourceBundle(@Nonnull InputStream aIS) throws IOException {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        Properties aProps = new Properties();
        aProps.loadFromXML(aIS);
        for (Map.Entry<Object, Object> aEntry : aProps.entrySet()) {
            this.m_aValues.put((String)aEntry.getKey(), (String)aEntry.getValue());
        }
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.m_aValues.keySet();
    }

    @Override
    protected String handleGetObject(@Nullable String sKey) {
        return this.m_aValues.get(sKey);
    }

    @Override
    public Enumeration<String> getKeys() {
        return ContainerHelper.getEnumeration(this.m_aValues.keySet());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String sBaseName) {
        return (XMLResourceBundle)ResourceBundle.getBundle(sBaseName, new XMLResourceBundleControl());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String sBaseName, @Nonnull Locale aLocale) {
        return (XMLResourceBundle)ResourceBundle.getBundle(sBaseName, aLocale, new XMLResourceBundleControl());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String sBaseName, @Nonnull Locale aLocale, @Nonnull ClassLoader aClassLoader) {
        return (XMLResourceBundle)ResourceBundle.getBundle(sBaseName, aLocale, aClassLoader, new XMLResourceBundleControl());
    }
}

