/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.rule;

import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.typeconvert.ITypeConverterRule;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRule;
import javax.annotation.Nonnull;

public abstract class AbstractTypeConverterRuleAssignableSourceFixedDestination
extends AbstractTypeConverterRule {
    private final Class<?> m_aSrcClass;
    private final Class<?> m_aDstClass;

    public AbstractTypeConverterRuleAssignableSourceFixedDestination(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass) {
        super(ITypeConverterRule.ESubType.ASSIGNABLE_SRC_FIXED_DST);
        if (aSrcClass == null) {
            throw new NullPointerException("srcClass");
        }
        if (aDstClass == null) {
            throw new NullPointerException("dstClass");
        }
        this.m_aSrcClass = aSrcClass;
        this.m_aDstClass = aDstClass;
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass) {
        return this.m_aDstClass.equals(aDstClass) && this.m_aSrcClass.isAssignableFrom(aSrcClass);
    }

    @Nonnull
    public final Class<?> getSourceClass() {
        return this.m_aSrcClass;
    }

    @Nonnull
    public final Class<?> getDestinationClass() {
        return this.m_aDstClass;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("srcClass", this.m_aSrcClass.getName()).append("dstClass", this.m_aDstClass.getName()).toString();
    }
}

