/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.URLProtocolRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class URLProtocol
implements IURLProtocol {
    private final String m_sProtocol;
    private final boolean m_bAllowsForQueryParameters;

    public URLProtocol(@Nonnull @Nonempty String sProtocol, boolean bAllowsForQueryParameters) {
        this.m_sProtocol = sProtocol;
        this.m_bAllowsForQueryParameters = bAllowsForQueryParameters;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getProtocol() {
        return this.m_sProtocol;
    }

    @Override
    public boolean isUsedInURL(@Nullable String sURL) {
        return sURL != null && sURL.startsWith(this.m_sProtocol);
    }

    @Override
    @Nullable
    public String getWithProtocol(@Nullable String sURL) {
        if (sURL == null) {
            return null;
        }
        return this.m_sProtocol + sURL;
    }

    @Override
    @Nullable
    public String getWithProtocolIfNone(@Nullable String sURL) {
        if (sURL == null || URLProtocolRegistry.hasKnownProtocol(sURL)) {
            return sURL;
        }
        return this.m_sProtocol + sURL;
    }

    @Override
    public boolean allowsForQueryParameters() {
        return this.m_bAllowsForQueryParameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        URLProtocol rhs = (URLProtocol)o;
        return this.m_sProtocol.equals(rhs.m_sProtocol) && this.m_bAllowsForQueryParameters == rhs.m_bAllowsForQueryParameters;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sProtocol).append(this.m_bAllowsForQueryParameters).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("protocol", this.m_sProtocol).append("queryParams", this.m_bAllowsForQueryParameters).toString();
    }
}

