/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import java.util.Iterator;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SimpleType;

public class EventIteratorToReceiver {
    private EventIteratorToReceiver() {
    }

    public static void copy(EventIterator in, SequenceReceiver out) throws XPathException {
        PullEvent event;
        in = EventStackIterator.flatten(in);
        int level = 0;
        out.open();
        while ((event = in.next()) != null) {
            if (event instanceof Orphan && ((Orphan)event).getNodeKind() == 3) {
                out.characters(((Orphan)event).getStringValueCS(), 0, 0);
                continue;
            }
            if (event instanceof DocumentInfo && level > 0) {
                Object node;
                AxisIterator kids = ((DocumentInfo)event).iterateAxis((byte)3);
                while ((node = kids.next()) != null) {
                    out.append((Item)node, 0, 0);
                }
                continue;
            }
            if (event instanceof Item) {
                out.append((Item)event, 0, 2);
                continue;
            }
            if (event instanceof StartElementEvent) {
                NamespaceBinding[] localNamespaces;
                StartElementEvent see = (StartElementEvent)event;
                ++level;
                out.startElement(see.getElementName(), see.getTypeCode(), 0, 64);
                for (NamespaceBinding ns : localNamespaces = see.getLocalNamespaces()) {
                    if (ns == null) break;
                    out.namespace(ns, 0);
                }
                if (see.hasAttributes()) {
                    Iterator ai = see.iterateAttributes();
                    while (ai.hasNext()) {
                        NodeInfo att = (NodeInfo)ai.next();
                        out.attribute(new NameOfNode(att), (SimpleType)att.getSchemaType(), att.getStringValueCS(), 0, 0);
                    }
                }
                out.startContent();
                continue;
            }
            if (event instanceof EndElementEvent) {
                --level;
                out.endElement();
                continue;
            }
            if (event instanceof StartDocumentEvent) {
                if (level == 0) {
                    out.startDocument(0);
                } else {
                    out.characters("", 0, 0);
                }
                ++level;
                continue;
            }
            if (event instanceof EndDocumentEvent) {
                if (--level == 0) {
                    out.endDocument();
                    continue;
                }
                out.characters("", 0, 0);
                continue;
            }
            throw new AssertionError((Object)("Unknown event class " + event.getClass()));
        }
        out.close();
    }
}

