/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FileAttribute;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.http.HttpRequestMessage;

public class LogFilter
extends ResourceFilter {
    public static final String DONT_LOG = "org.w3c.jigsaw.filters.LogFilter.nolog";
    protected static int ATTR_REQUEST_HEADERS = -1;
    protected static int ATTR_REPLY_HEADERS = -1;
    protected static int ATTR_LOGFILE = -1;
    protected HeaderDescription[] reqheaders = null;
    protected HeaderDescription[] repheaders = null;
    protected RandomAccessFile log = null;

    protected HeaderDescription[] compileHeaders(HttpMessage httpMessage, String[] stringArray) {
        Enumeration enumeration = httpMessage.enumerateHeaderDescriptions(true);
        HeaderDescription[] headerDescriptionArray = new HeaderDescription[stringArray.length];
        block0: while (enumeration.hasMoreElements()) {
            HeaderDescription headerDescription = (HeaderDescription)enumeration.nextElement();
            if (headerDescription == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(headerDescription.getName())) continue;
                headerDescriptionArray[i] = headerDescription;
                continue block0;
            }
        }
        return headerDescriptionArray;
    }

    protected synchronized void writelog(String string) {
        block3: {
            try {
                if (this.log != null) {
                    this.log.writeBytes(string);
                }
            }
            catch (IOException iOException) {
                FramedResource framedResource = (FramedResource)this.getTargetResource();
                if (framedResource == null) break block3;
                String string2 = "IO error while writing to log file \"" + iOException.getMessage() + "\".";
                framedResource.getServer().errlog(this, string2);
            }
        }
    }

    protected synchronized void openLog() {
        FramedResource framedResource;
        if (this.log != null) {
            try {
                this.log.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.log = null;
        }
        File file = this.getLogfile();
        try {
            if (file != null) {
                this.log = new RandomAccessFile(file, "rw");
                this.log.seek(this.log.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.log == null && (framedResource = (FramedResource)this.getTargetResource()) != null) {
            String string = "unable to open log file \"" + file + "\".";
            framedResource.getServer().errlog(this, string);
        }
    }

    public File getLogfile() {
        return (File)this.getValue(ATTR_LOGFILE, null);
    }

    public String[] getRequestHeaders() {
        return (String[])this.getValue(ATTR_REQUEST_HEADERS, null);
    }

    public String[] getReplyHeaders() {
        return (String[])this.getValue(ATTR_REPLY_HEADERS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_REQUEST_HEADERS) {
            LogFilter logFilter = this;
            synchronized (logFilter) {
                this.reqheaders = this.compileHeaders(new HttpRequestMessage(), (String[])object);
            }
        } else if (n == ATTR_REPLY_HEADERS) {
            LogFilter logFilter = this;
            synchronized (logFilter) {
                this.repheaders = this.compileHeaders(new HttpReplyMessage(), (String[])object);
            }
        } else if (n == ATTR_LOGFILE) {
            this.openLog();
        }
    }

    protected void log(Request request, Reply reply) {
        HeaderValue headerValue;
        HeaderDescription headerDescription;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("url=");
        stringBuffer.append(request.getURL().toString());
        stringBuffer.append('\n');
        if (this.reqheaders != null) {
            for (n = 0; n < this.reqheaders.length; ++n) {
                headerDescription = this.reqheaders[n];
                if (headerDescription == null || (headerValue = request.getHeaderValue(headerDescription)) == null) continue;
                stringBuffer.append("request.");
                stringBuffer.append(headerDescription.getName());
                stringBuffer.append('=');
                stringBuffer.append(headerValue.toString());
                stringBuffer.append('\n');
            }
        }
        if (this.repheaders != null) {
            for (n = 0; n < this.repheaders.length; ++n) {
                headerDescription = this.repheaders[n];
                if (headerDescription == null || (headerValue = reply.getHeaderValue(headerDescription)) == null) continue;
                stringBuffer.append("reply.");
                stringBuffer.append(headerDescription.getName());
                stringBuffer.append('=');
                stringBuffer.append(headerValue.toString());
                stringBuffer.append('\n');
            }
        }
        this.writelog(stringBuffer.toString());
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) throws ProtocolException {
        Reply reply = (Reply)replyInterface;
        Request request = (Request)requestInterface;
        if (!reply.hasState(DONT_LOG)) {
            this.log(request, reply);
        }
        return null;
    }

    public void initialize(Object[] objectArray) {
        String[] stringArray;
        super.initialize(objectArray);
        if (this.log == null) {
            this.openLog();
        }
        if (this.reqheaders == null && (stringArray = this.getRequestHeaders()) != null) {
            this.reqheaders = this.compileHeaders(new HttpRequestMessage(), stringArray);
        }
        if (this.repheaders == null && (stringArray = this.getReplyHeaders()) != null) {
            this.repheaders = this.compileHeaders(new HttpReplyMessage(), stringArray);
        }
    }

    static {
        Class<?> clazz = null;
        Attribute attribute = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.LogFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new StringArrayAttribute("request-headers", null, 2);
        ATTR_REQUEST_HEADERS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("reply-headers", null, 2);
        ATTR_REPLY_HEADERS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new FileAttribute("logfile", null, 2);
        ATTR_LOGFILE = AttributeRegistry.registerAttribute(clazz, attribute);
    }
}

