/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.changelog;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.callback.INonThrowingRunnableWithParameter;
import com.phloc.commons.changelog.AbstractChangeLogEntry;
import com.phloc.commons.changelog.ChangeLog;
import com.phloc.commons.changelog.ChangeLogEntry;
import com.phloc.commons.changelog.ChangeLogRelease;
import com.phloc.commons.changelog.EChangeLogAction;
import com.phloc.commons.changelog.EChangeLogCategory;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.convert.MicroTypeConverter;
import com.phloc.commons.microdom.impl.MicroDocument;
import com.phloc.commons.microdom.serialize.MicroReader;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.text.impl.MultiLingualText;
import com.phloc.commons.version.Version;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ChangeLogSerializer {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ChangeLogSerializer.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String ELEMENT_CHANGELOG = "changelog";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_COMPONENT = "component";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ATTR_DATE = "date";
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_INCOMPATIBLE = "incompatible";
    private static final String ELEMENT_CHANGE = "change";
    private static final String ELEMENT_ISSUE = "issue";
    private static final String ELEMENT_RELEASE = "release";
    private static final ChangeLogSerializer s_aInstance = new ChangeLogSerializer();
    private static final INonThrowingRunnableWithParameter<String> s_aLoggingCallback = new INonThrowingRunnableWithParameter<String>(){

        @Override
        public void run(String sError) {
            s_aLogger.error(sError);
        }
    };

    private ChangeLogSerializer() {
    }

    @Nullable
    public static ChangeLog readChangeLog(@Nullable IInputStreamProvider aISP) {
        return ChangeLogSerializer.readChangeLog(aISP, s_aLoggingCallback);
    }

    @Nullable
    public static ChangeLog readChangeLog(@Nullable IInputStreamProvider aISP, @Nonnull INonThrowingRunnableWithParameter<String> aErrorCallback) {
        if (aErrorCallback == null) {
            throw new NullPointerException("errorCallback");
        }
        IMicroDocument aDoc = MicroReader.readMicroXML(aISP);
        if (aDoc == null) {
            return null;
        }
        IMicroElement eRoot = aDoc.getDocumentElement();
        if (eRoot == null) {
            return null;
        }
        ChangeLog ret = new ChangeLog(new Version(eRoot.getAttribute(ATTR_VERSION)), eRoot.getAttribute(ATTR_COMPONENT));
        SimpleDateFormat aDF = new SimpleDateFormat(DATE_FORMAT);
        for (IMicroElement eElement : eRoot.getChildElements()) {
            String sDate;
            if (!"http://www.phloc.com/ns/changelog/1.0".equals(eElement.getNamespaceURI())) {
                aErrorCallback.run("Element '" + eElement.getTagName() + "' has the wrong namespace URI '" + eElement.getNamespaceURI() + "'");
                continue;
            }
            String sTagName = eElement.getTagName();
            if (ELEMENT_ENTRY.equals(sTagName)) {
                sDate = eElement.getAttribute(ATTR_DATE);
                String sAction = eElement.getAttribute(ATTR_ACTION);
                String sCategory = eElement.getAttribute(ATTR_CATEGORY);
                String sIncompatible = eElement.getAttribute(ATTR_INCOMPATIBLE);
                Date aDate = null;
                try {
                    aDate = aDF.parse(sDate);
                }
                catch (ParseException ex) {
                    aErrorCallback.run("Failed to parse entry date '" + sDate + "'");
                    continue;
                }
                EChangeLogAction eAction = EChangeLogAction.getFromIDOrNull(sAction);
                if (eAction == null) {
                    aErrorCallback.run("Failed to parse change log action '" + sAction + "'");
                    continue;
                }
                EChangeLogCategory eCategory = EChangeLogCategory.getFromIDOrNull(sCategory);
                if (eCategory == null) {
                    aErrorCallback.run("Failed to parse change log category '" + sCategory + "'");
                    continue;
                }
                boolean bIsIncompatible = StringHelper.hasText(sIncompatible) ? StringParser.parseBool(sIncompatible) : false;
                ChangeLogEntry aEntry = new ChangeLogEntry(ret, aDate, eAction, eCategory, bIsIncompatible);
                ret.addEntry(aEntry);
                IMicroElement eChange = eElement.getFirstChildElement("http://www.phloc.com/ns/changelog/1.0", ELEMENT_CHANGE);
                if (eChange == null) {
                    aErrorCallback.run("No change element present!");
                    continue;
                }
                MultiLingualText aMLT = MicroTypeConverter.convertToNative(eChange, MultiLingualText.class);
                if (aMLT == null) {
                    aErrorCallback.run("Failed to read multi lingual text in change element!");
                    continue;
                }
                aEntry.setText(aMLT);
                for (IMicroElement eIssue : eElement.getChildElements("http://www.phloc.com/ns/changelog/1.0", ELEMENT_ISSUE)) {
                    aEntry.addIssue(eIssue.getTextContent());
                }
                continue;
            }
            if (ELEMENT_RELEASE.equals(sTagName)) {
                sDate = eElement.getAttribute(ATTR_DATE);
                String sVersion = eElement.getAttribute(ATTR_VERSION);
                Date aDate = null;
                try {
                    aDate = aDF.parse(sDate);
                }
                catch (ParseException ex) {
                    s_aLogger.warn("Failed to parse release date '" + sDate + "'");
                    continue;
                }
                ret.addRelease(new ChangeLogRelease(aDate, new Version(sVersion, false)));
                continue;
            }
            aErrorCallback.run("Changelog contains unsupported element '" + sTagName + "!");
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<URI, ChangeLog> readAllChangeLogs() {
        return ChangeLogSerializer.readAllChangeLogs(s_aLoggingCallback);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<URI, ChangeLog> readAllChangeLogs(@Nonnull ClassLoader aClassLoader) {
        return ChangeLogSerializer.readAllChangeLogs(s_aLoggingCallback, aClassLoader);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<URI, ChangeLog> readAllChangeLogs(@Nonnull INonThrowingRunnableWithParameter<String> aErrorCallback) {
        return ChangeLogSerializer.readAllChangeLogs(aErrorCallback, ClassHelper.getDefaultClassLoader());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<URI, ChangeLog> readAllChangeLogs(@Nonnull INonThrowingRunnableWithParameter<String> aErrorCallback, @Nonnull ClassLoader aClassLoader) {
        if (aErrorCallback == null) {
            throw new NullPointerException("errorCallback");
        }
        if (aClassLoader == null) {
            throw new NullPointerException("classLoader");
        }
        try {
            HashMap<URI, ChangeLog> ret = new HashMap<URI, ChangeLog>();
            for (URL aURL : ContainerHelper.newList(aClassLoader.getResources("changelog.xml"))) {
                ChangeLog aChangeLog = ChangeLogSerializer.readChangeLog(new URLResource(aURL), aErrorCallback);
                if (aChangeLog != null) {
                    ret.put(aURL.toURI(), aChangeLog);
                    continue;
                }
                s_aLogger.warn("Failed to read changelog from URL " + aURL.toExternalForm());
            }
            return ret;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to resolved changelogs", ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Failed to convert URL to URI", ex);
        }
    }

    @Nonnull
    public static IMicroDocument writeChangeLog(@Nonnull ChangeLog aChangeLog) {
        if (aChangeLog == null) {
            throw new NullPointerException("changeLog");
        }
        SimpleDateFormat aDF = new SimpleDateFormat(DATE_FORMAT);
        MicroDocument ret = new MicroDocument();
        IMicroElement eRoot = ret.appendElement("http://www.phloc.com/ns/changelog/1.0", ELEMENT_CHANGELOG);
        eRoot.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        eRoot.setAttribute("xsi:schemaLocation", "http://www.phloc.com/ns/changelog/1.0 schemas/changelog-1.0.xsd");
        eRoot.setAttribute(ATTR_VERSION, aChangeLog.getVersion().getAsString());
        if (StringHelper.hasText(aChangeLog.getComponent())) {
            eRoot.setAttribute(ATTR_COMPONENT, aChangeLog.getComponent());
        }
        for (AbstractChangeLogEntry aBaseEntry : aChangeLog.getAllBaseEntries()) {
            if (aBaseEntry instanceof ChangeLogEntry) {
                ChangeLogEntry aEntry = (ChangeLogEntry)aBaseEntry;
                IMicroElement eEntry = eRoot.appendElement("http://www.phloc.com/ns/changelog/1.0", ELEMENT_ENTRY);
                eEntry.setAttribute(ATTR_DATE, aDF.format(aEntry.getDate()));
                eEntry.setAttribute(ATTR_ACTION, aEntry.getAction().getID());
                eEntry.setAttribute(ATTR_CATEGORY, aEntry.getCategory().getID());
                if (aEntry.isIncompatible()) {
                    eEntry.setAttribute(ATTR_INCOMPATIBLE, Boolean.TRUE.toString());
                }
                eEntry.appendChild(MicroTypeConverter.convertToMicroElement(aEntry.getAllTexts(), "http://www.phloc.com/ns/changelog/1.0", ELEMENT_CHANGE));
                for (String sIssue : aEntry.getAllIssues()) {
                    eEntry.appendElement("http://www.phloc.com/ns/changelog/1.0", ELEMENT_ISSUE).appendText(sIssue);
                }
                continue;
            }
            ChangeLogRelease aRelease = (ChangeLogRelease)aBaseEntry;
            IMicroElement eRelease = eRoot.appendElement("http://www.phloc.com/ns/changelog/1.0", ELEMENT_RELEASE);
            eRelease.setAttribute(ATTR_DATE, aDF.format(aRelease.getDate()));
            eRelease.setAttribute(ATTR_VERSION, aRelease.getVersion().getAsString());
        }
        return ret;
    }
}

