/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.attrs;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.attrs.AbstractReadonlyAttributeContainer;
import com.phloc.commons.collections.attrs.IAttributeContainer;
import com.phloc.commons.collections.attrs.IReadonlyAttributeContainer;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedAttributeContainer
extends AbstractReadonlyAttributeContainer
implements IAttributeContainer {
    protected final Map<String, Object> m_aAttrs = new HashMap<String, Object>();

    public MapBasedAttributeContainer() {
    }

    public MapBasedAttributeContainer(@Nonnull Map<String, Object> aMap) {
        if (aMap == null) {
            throw new NullPointerException("map");
        }
        this.m_aAttrs.putAll(aMap);
    }

    public MapBasedAttributeContainer(@Nonnull IReadonlyAttributeContainer aCont) {
        if (aCont == null) {
            throw new NullPointerException("cont");
        }
        this.m_aAttrs.putAll(aCont.getAllAttributes());
    }

    @Override
    public boolean containsAttribute(@Nullable String sName) {
        return sName != null && this.m_aAttrs.containsKey(sName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, Object> getAllAttributes() {
        return ContainerHelper.newMap(this.m_aAttrs);
    }

    @Override
    @Nullable
    public Object getAttributeObject(@Nullable String sName) {
        return sName == null ? null : this.m_aAttrs.get(sName);
    }

    @Override
    @Nonnull
    public EChange setAttribute(@Nonnull String sName, @Nullable Object aValue) {
        if (sName == null) {
            throw new NullPointerException("name");
        }
        if (aValue == null) {
            return this.removeAttribute(sName);
        }
        Object aOldValue = this.m_aAttrs.put(sName, aValue);
        return EChange.valueOf(!EqualsUtils.equals(aValue, aOldValue));
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable String sName) {
        return EChange.valueOf(sName != null && this.m_aAttrs.remove(sName) != null);
    }

    @Override
    @Nonnull
    public Enumeration<String> getAttributeNames() {
        return ContainerHelper.getEnumeration(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllAttributeNames() {
        return ContainerHelper.newSet(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<Object> getAllAttributeValues() {
        return ContainerHelper.newList(this.m_aAttrs.values());
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs.size();
    }

    @Override
    public boolean containsNoAttribute() {
        return this.m_aAttrs.isEmpty();
    }

    @Override
    public boolean getAndSetAttributeFlag(@Nonnull String sName) {
        Object aOldValue = this.getAttributeObject(sName);
        if (aOldValue != null) {
            return true;
        }
        this.setAttribute(sName, Boolean.TRUE);
        return false;
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aAttrs.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aAttrs.clear();
        return EChange.CHANGED;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        MapBasedAttributeContainer rhs = (MapBasedAttributeContainer)o;
        return ((Object)this.m_aAttrs).equals(rhs.m_aAttrs);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aAttrs)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("attrs", this.m_aAttrs).toString();
    }
}

