/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.convert.collections;

import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.convert.IUnidirectionalConverter;
import com.phloc.commons.filter.IFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ContainerConversionHelper {
    private static final ContainerConversionHelper s_aInstance = new ContainerConversionHelper();

    private ContainerConversionHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newSet(@Nonnull Iterator<? extends SRCTYPE> it, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        HashSet<DSTTYPE> ret = new HashSet<DSTTYPE>();
        while (it.hasNext()) {
            ret.add(aConverter.convert(it.next()));
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newSet(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        HashSet<DSTTYPE> ret = new HashSet<DSTTYPE>();
        for (SRCTYPE aValue : aCont) {
            ret.add(aConverter.convert(aValue));
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newSet(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IFilter<? super SRCTYPE> aFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        HashSet<DSTTYPE> ret = new HashSet<DSTTYPE>();
        for (SRCTYPE aIn : aCont) {
            if (!aFilter.matchesFilter(aIn)) continue;
            ret.add(aConverter.convert(aIn));
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableSet(@Nonnull Iterator<? extends SRCTYPE> it, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newSet(it, aConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableSet(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newSet(aCont, aConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableSet(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IFilter<? super SRCTYPE> aFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newSet(aCont, aFilter, aConverter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newOrderedSet(@Nonnull Iterator<? extends SRCTYPE> it, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        LinkedHashSet<DSTTYPE> ret = new LinkedHashSet<DSTTYPE>();
        while (it.hasNext()) {
            ret.add(aConverter.convert(it.next()));
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newOrderedSet(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        LinkedHashSet<DSTTYPE> ret = new LinkedHashSet<DSTTYPE>();
        for (SRCTYPE aValue : aCont) {
            ret.add(aConverter.convert(aValue));
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newOrderedSet(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IFilter<? super SRCTYPE> aFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        LinkedHashSet<DSTTYPE> ret = new LinkedHashSet<DSTTYPE>();
        for (SRCTYPE aIn : aCont) {
            if (!aFilter.matchesFilter(aIn)) continue;
            ret.add(aConverter.convert(aIn));
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterator<? extends SRCTYPE> it, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newOrderedSet(it, aConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newOrderedSet(aCont, aConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IFilter<? super SRCTYPE> aFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newOrderedSet(aCont, aFilter, aConverter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newList(@Nullable Iterable<? extends SRCTYPE> aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        ArrayList<DSTTYPE> ret = new ArrayList<DSTTYPE>();
        if (aCont != null) {
            for (SRCTYPE aIn : aCont) {
                ret.add(aConverter.convert(aIn));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newList(@Nullable SRCTYPE[] aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        ArrayList<DSTTYPE> ret = new ArrayList<DSTTYPE>(ArrayHelper.getSize(aCont));
        if (aCont != null) {
            for (SRCTYPE aIn : aCont) {
                ret.add(aConverter.convert(aIn));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newList(@Nullable Iterable<? extends SRCTYPE> aCont, @Nonnull IFilter<? super SRCTYPE> aFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        ArrayList<DSTTYPE> ret = new ArrayList<DSTTYPE>();
        if (aCont != null) {
            for (SRCTYPE aIn : aCont) {
                if (!aFilter.matchesFilter(aIn)) continue;
                ret.add(aConverter.convert(aIn));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newUnmodifiableList(@Nullable Iterable<? extends SRCTYPE> aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newList(aCont, aConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newUnmodifiableList(@Nullable SRCTYPE[] aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newList(aCont, aConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newUnmodifiableList(@Nullable Iterable<? extends SRCTYPE> aCont, @Nonnull IFilter<? super SRCTYPE> aFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newList(aCont, aFilter, aConverter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> List<DSTTYPE> getSorted(@Nonnull Iterator<? extends SRCTYPE> it, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        if (it == null) {
            throw new NullPointerException("iterator");
        }
        if (aConverter == null) {
            throw new NullPointerException("comparator");
        }
        ArrayList<DSTTYPE> ret = new ArrayList<DSTTYPE>();
        while (it.hasNext()) {
            ret.add(aConverter.convert(it.next()));
        }
        return ContainerHelper.getSortedInline(ret);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> getSorted(@Nonnull Iterator<? extends SRCTYPE> it, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter, @Nonnull Comparator<? super DSTTYPE> aComparator) {
        if (it == null) {
            throw new NullPointerException("iterator");
        }
        if (aConverter == null) {
            throw new NullPointerException("converter");
        }
        if (aComparator == null) {
            throw new NullPointerException("comparator");
        }
        ArrayList<DSTTYPE> ret = new ArrayList<DSTTYPE>();
        while (it.hasNext()) {
            ret.add(aConverter.convert(it.next()));
        }
        return ContainerHelper.getSortedInline(ret, aComparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> List<DSTTYPE> getSorted(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        if (aCont == null) {
            throw new NullPointerException("container");
        }
        if (aConverter == null) {
            throw new NullPointerException("converter");
        }
        ArrayList<DSTTYPE> ret = new ArrayList<DSTTYPE>();
        for (SRCTYPE aSrc : aCont) {
            ret.add(aConverter.convert(aSrc));
        }
        return ContainerHelper.getSortedInline(ret);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> getSorted(@Nonnull Iterable<? extends SRCTYPE> aCont, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter, @Nonnull Comparator<? super DSTTYPE> aComparator) {
        if (aCont == null) {
            throw new NullPointerException("container");
        }
        if (aConverter == null) {
            throw new NullPointerException("converter");
        }
        if (aComparator == null) {
            throw new NullPointerException("comparator");
        }
        ArrayList<DSTTYPE> ret = new ArrayList<DSTTYPE>();
        for (SRCTYPE aSrc : aCont) {
            ret.add(aConverter.convert(aSrc));
        }
        return ContainerHelper.getSortedInline(ret, aComparator);
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> Iterator<DSTTYPE> getIterator(final @Nonnull Iterable<SRCTYPE> aCont, final @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> aConverter) {
        if (aCont == null) {
            throw new NullPointerException("cont");
        }
        if (aConverter == null) {
            throw new NullPointerException("converter");
        }
        return new Iterator<DSTTYPE>(){
            private final Iterator<SRCTYPE> m_aIT;
            {
                this.m_aIT = aCont.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.m_aIT.hasNext();
            }

            @Override
            public DSTTYPE next() {
                return aConverter.convert(this.m_aIT.next());
            }

            @Override
            public void remove() {
                this.m_aIT.remove();
            }
        };
    }
}

