/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.ILongIDFactory;
import com.phloc.commons.string.ToStringGenerator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractPersistingLongIDFactory
implements ILongIDFactory {
    private final Lock m_aLock = new ReentrantLock();
    private final int m_nReserveCount;
    private long m_nID = 0L;
    private long m_nLastID = -1L;

    public AbstractPersistingLongIDFactory(@Nonnegative int nReserveCount) {
        if (nReserveCount < 1) {
            throw new IllegalArgumentException("reserve count illegal: " + nReserveCount);
        }
        this.m_nReserveCount = nReserveCount;
    }

    @Nonnegative
    protected final int getReserveCount() {
        return this.m_nReserveCount;
    }

    protected abstract long readAndUpdateIDCounter(@Nonnegative int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getNewID() {
        this.m_aLock.lock();
        try {
            if (this.m_nID >= this.m_nLastID) {
                long nNewID = this.readAndUpdateIDCounter(this.m_nReserveCount);
                if (this.m_nLastID >= 0L && nNewID < this.m_nID) {
                    throw new IllegalStateException("The read value " + nNewID + " is smaller than the last known ID " + this.m_nID + "!");
                }
                this.m_nID = nNewID;
                this.m_nLastID = nNewID + (long)this.m_nReserveCount;
            }
            long l = this.m_nID++;
            return l;
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractPersistingLongIDFactory rhs = (AbstractPersistingLongIDFactory)o;
        return this.m_nReserveCount == rhs.m_nReserveCount && this.m_nID == rhs.m_nID;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nReserveCount).append(this.m_nID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("reserveCount", this.m_nReserveCount).append("ID", this.m_nID).append("lastID", this.m_nLastID).toString();
    }
}

