/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.utils;

import com.phloc.commons.hierarchy.IHierarchyWalkerCallback;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.parent.IChildrenProvider;
import com.phloc.commons.parent.impl.ChildrenProviderHasChildren;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroWalker {
    private static final MicroWalker s_aInstance = new MicroWalker();

    private MicroWalker() {
    }

    private static <T extends IMicroNode> void _walkNode(@Nonnull T aNode, @Nonnull IChildrenProvider<T> aChildrenResolver, @Nonnull IHierarchyWalkerCallback<? super T> aCallback) {
        aCallback.onItemBeforeChildren(aNode);
        if (aChildrenResolver.hasChildren(aNode)) {
            for (IMicroNode aChildItem : aChildrenResolver.getChildren(aNode)) {
                aCallback.onLevelDown();
                MicroWalker._walkNode(aChildItem, aChildrenResolver, aCallback);
                aCallback.onLevelUp();
            }
        }
        aCallback.onItemAfterChildren(aNode);
    }

    public static void walkNode(@Nonnull IMicroNode aNode, @Nonnull IHierarchyWalkerCallback<? super IMicroNode> aCallback) {
        MicroWalker.walkNode(aNode, new ChildrenProviderHasChildren(), aCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IMicroNode> void walkNode(@Nonnull T aNode, @Nonnull IChildrenProvider<T> aChildrenResolver, @Nonnull IHierarchyWalkerCallback<? super T> aCallback) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (aCallback == null) {
            throw new NullPointerException("callback");
        }
        aCallback.begin();
        try {
            if (aChildrenResolver.hasChildren(aNode)) {
                for (IMicroNode aChildItem : aChildrenResolver.getChildren(aNode)) {
                    MicroWalker._walkNode(aChildItem, aChildrenResolver, aCallback);
                }
            }
        }
        finally {
            aCallback.end();
        }
    }
}

