/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.build;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.id.IHasID;
import com.phloc.commons.parent.IChildrenProvider;
import com.phloc.commons.parent.IHasParent;
import com.phloc.commons.parent.IParentProvider;
import com.phloc.commons.parent.impl.ParentProviderHasParent;
import com.phloc.commons.tree.withid.DefaultTreeItemWithID;
import com.phloc.commons.tree.withid.DefaultTreeWithID;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWithIDBuilder {
    private static final TreeWithIDBuilder s_aInstance = new TreeWithIDBuilder();

    private TreeWithIDBuilder() {
    }

    @Nonnull
    private static <KEYTYPE, VALUETYPE extends IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, VALUETYPE> _buildTree(@Nonnull List<VALUETYPE> aOpen, @Nonnull IParentProvider<VALUETYPE> aParentResolver) {
        DefaultTreeWithID aTree = new DefaultTreeWithID();
        HashMap aIDMap = new HashMap();
        int nMovedToBackCount = 0;
        while (!aOpen.isEmpty()) {
            IHasID aCurrent = (IHasID)aOpen.remove(0);
            IHasID aParent = aParentResolver.getParent(aCurrent);
            Object aCurrentID = aCurrent.getID();
            if (aParent == null) {
                DefaultTreeItemWithID aNewItem = (DefaultTreeItemWithID)((DefaultTreeItemWithID)aTree.getRootItem()).createChildItem(aCurrentID, aCurrent);
                aIDMap.put(aCurrentID, aNewItem);
                nMovedToBackCount = 0;
                continue;
            }
            Object aParentID = aParent.getID();
            if (aIDMap.containsKey(aParentID)) {
                DefaultTreeItemWithID aParentItem = (DefaultTreeItemWithID)aIDMap.get(aParentID);
                DefaultTreeItemWithID aNewItem = (DefaultTreeItemWithID)aParentItem.createChildItem(aCurrentID, aCurrent);
                aIDMap.put(aCurrentID, aNewItem);
                nMovedToBackCount = 0;
                continue;
            }
            aOpen.add(aCurrent);
            if (++nMovedToBackCount != aOpen.size()) continue;
            throw new IllegalStateException("The hierarchy is illegal. It contains elements that fit nowhere in the tree: " + aOpen);
        }
        return aTree;
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE extends IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, VALUETYPE> buildTree(@Nonnull Collection<? extends VALUETYPE> aAll, @Nonnull IParentProvider<VALUETYPE> aParentResolver) {
        if (aAll == null) {
            throw new NullPointerException("all");
        }
        if (aParentResolver == null) {
            throw new NullPointerException("parentResolver");
        }
        return TreeWithIDBuilder._buildTree(ContainerHelper.newList(aAll), aParentResolver);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE extends IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, VALUETYPE> buildTree(@Nonnull VALUETYPE[] aAll, @Nonnull IParentProvider<VALUETYPE> aParentResolver) {
        if (aAll == null) {
            throw new NullPointerException("all");
        }
        if (aParentResolver == null) {
            throw new NullPointerException("parentResolver");
        }
        return TreeWithIDBuilder._buildTree(ContainerHelper.newList(aAll), aParentResolver);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE extends IHasParent<VALUETYPE> & IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, VALUETYPE> buildTree(@Nonnull Collection<? extends VALUETYPE> aAll) {
        if (aAll == null) {
            throw new NullPointerException("all");
        }
        return TreeWithIDBuilder.buildTree(aAll, new ParentProviderHasParent());
    }

    private static <KEYTYPE, VALUETYPE extends IHasID<KEYTYPE>> void _buildTreeRecursive(@Nullable DefaultTreeItemWithID<KEYTYPE, VALUETYPE> aParentItem, @Nonnull IChildrenProvider<VALUETYPE> aChildrenResolver) {
        IHasID aParentObject;
        if (aParentItem != null && aChildrenResolver.hasChildren(aParentObject = (IHasID)aParentItem.getData())) {
            for (IHasID aChild : aChildrenResolver.getChildren(aParentObject)) {
                DefaultTreeItemWithID aItem = (DefaultTreeItemWithID)aParentItem.createChildItem(aChild.getID(), aChild);
                TreeWithIDBuilder._buildTreeRecursive(aItem, aChildrenResolver);
            }
        }
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE extends IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, VALUETYPE> buildTree(@Nonnull IChildrenProvider<VALUETYPE> aChildrenResolver) {
        if (aChildrenResolver == null) {
            throw new NullPointerException("childrenResolver");
        }
        DefaultTreeWithID aTree = new DefaultTreeWithID();
        if (aChildrenResolver.hasChildren(null)) {
            for (IHasID iHasID : aChildrenResolver.getChildren(null)) {
                DefaultTreeItemWithID aItem = (DefaultTreeItemWithID)((DefaultTreeItemWithID)aTree.getRootItem()).createChildItem(iHasID.getID(), iHasID);
                TreeWithIDBuilder._buildTreeRecursive(aItem, aChildrenResolver);
            }
        }
        return aTree;
    }
}

