<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:fo="http://www.w3.org/1999/XSL/Format"
 version="1.0">
<xsl:import href="http://www.oucs.ox.ac.uk/stylesheets/tei-oucs.xsl"/>
<!-- page setup -->
<xsl:variable name="pageWidth">211mm</xsl:variable>
<xsl:variable name="pageHeight">297mm</xsl:variable>
<xsl:variable name="regionAfterExtent">12pt</xsl:variable>
<xsl:variable name="regionBeforeExtent">12pt</xsl:variable>
<xsl:variable name="bodyMarginBottom">24pt</xsl:variable>
<xsl:variable name="bodyMarginTop">24pt</xsl:variable>
<xsl:variable name="pageMarginTop">75pt</xsl:variable>
<xsl:variable name="pageMarginBottom">100pt</xsl:variable>
<xsl:variable name="pageMarginLeft">80pt</xsl:variable>
<xsl:variable name="pageMarginRight">150pt</xsl:variable>
<xsl:variable name="bodyFont">Times Roman</xsl:variable>
<xsl:variable name="divFont">Times Roman</xsl:variable>
<xsl:variable name="typewriterFont">Computer-Modern-Typewriter</xsl:variable>
<xsl:variable name="sansFont">Helvetica</xsl:variable>
<xsl:variable name="bodyMaster">10</xsl:variable>
<xsl:variable name="bodySize">
 <xsl:value-of select="$bodyMaster"/><xsl:text>pt</xsl:text>
</xsl:variable>
<xsl:variable name="smallSize">
 <xsl:value-of select="$bodyMaster * 0.9"/><xsl:text>pt</xsl:text>
</xsl:variable>
<xsl:variable name="flowMarginLeft"></xsl:variable>

<!-- general H&J setup -->
<xsl:variable name="hyphenate">true</xsl:variable>
<xsl:variable name="alignment">justify</xsl:variable>


<xsl:variable name="footnoteSize">8pt</xsl:variable>
<xsl:variable name="footnotenumSize">7pt</xsl:variable>
<xsl:variable name="authorSize">14pt</xsl:variable>
<xsl:variable name="dateSize">14pt</xsl:variable>
<xsl:variable name="titleSize">16pt</xsl:variable>

<xsl:variable name="biblSize">16pt</xsl:variable>
<xsl:variable name="headingOutdent">-3em</xsl:variable>
<xsl:variable name="linkColor">black</xsl:variable>
<xsl:variable name="giColor">orange</xsl:variable>
<xsl:variable name="identColor">blue</xsl:variable>
<xsl:variable name="parIndent">1em</xsl:variable>
<xsl:variable name="parSkip">0pt</xsl:variable>
<xsl:variable name="activeLinebreaks"></xsl:variable>
<xsl:variable name="activePagebreaks"></xsl:variable>
<xsl:variable name="inlineTables"></xsl:variable>
<xsl:variable name="tableCaptionAlign">center</xsl:variable>
<xsl:variable name="tableAlign">center</xsl:variable>
<xsl:variable name="spaceBelowCaption">4pt</xsl:variable>
<xsl:variable name="spaceAroundTable">8pt</xsl:variable>

<!-- table of contents customization -->
<xsl:variable name="tocSize">16pt</xsl:variable>
<xsl:variable name="div0Tocindent">0in</xsl:variable>
<xsl:variable name="div1Tocindent">0.25in</xsl:variable>
<xsl:variable name="div2Tocindent">0.5in</xsl:variable>
<xsl:variable name="div3Tocindent">0.75in</xsl:variable>
<xsl:variable name="div4Tocindent">1in</xsl:variable>
<xsl:variable name="tocFront">true</xsl:variable>
<xsl:variable name="tocBack">true</xsl:variable>
<xsl:variable name="headingNumberSuffix">. </xsl:variable>
<xsl:variable name="tocNumberSuffix">. </xsl:variable>

<!-- list customization -->
<xsl:variable name="listRightMargin">10pt</xsl:variable>
<xsl:variable name="listNormalIndent">15pt</xsl:variable>
<xsl:variable name="listLeftGlossIndent">0.5in</xsl:variable>
<xsl:variable name="listLeftGlossInnerIndent">0.25in</xsl:variable>
<xsl:variable name="listLeftIndent">15pt</xsl:variable>
<xsl:variable name="listItemsep">4pt</xsl:variable>
<xsl:variable name="listAbove-1">6pt</xsl:variable>
<xsl:variable name="listBelow-1">6pt</xsl:variable>
<xsl:variable name="listAbove-2">4pt</xsl:variable>
<xsl:variable name="listBelow-2">4pt</xsl:variable>
<xsl:variable name="listAbove-3">0pt</xsl:variable>
<xsl:variable name="listBelow-3">0pt</xsl:variable>
<xsl:variable name="listAbove-4">0pt</xsl:variable>
<xsl:variable name="listBelow-4">0pt</xsl:variable>
<xsl:variable name="bulletOne">&#x2022;</xsl:variable>
<xsl:variable name="bulletTwo">&#x2013;</xsl:variable>
<xsl:variable name="bulletThree">&#x002A;</xsl:variable>
<xsl:variable name="bulletFour">&#x002B;</xsl:variable>


<!-- example/quotation setup -->
<xsl:variable name="exampleSize">
 <xsl:value-of select="$bodyMaster * 0.8"/><xsl:text>pt</xsl:text>
</xsl:variable>
<xsl:variable name="exampleMargin">12pt</xsl:variable>
<xsl:variable name="exampleBefore">4pt</xsl:variable>
<xsl:variable name="exampleAfter">4pt</xsl:variable>

<!-- do we want a separate title sheet -->
<xsl:variable name="titlePage"></xsl:variable>

<!-- style for OUCS -->
<xsl:variable name="OUCS"></xsl:variable>

<!-- use bookmarks option in hyperref -->
<xsl:variable name="pdfBookmarks"></xsl:variable>
<xsl:variable name="divRunningheads"></xsl:variable>

<!-- default language -->
<xsl:variable name="language">US</xsl:variable>

<!-- page layout -->
<xsl:variable name="forcePageMaster"></xsl:variable>
<xsl:variable name="twoSided">true</xsl:variable>
<xsl:variable name="frontMulticolumns"></xsl:variable>
<xsl:variable name="bodyMulticolumns"></xsl:variable>
<xsl:variable name="backMulticolumns"></xsl:variable>
<xsl:variable name="columnCount">1</xsl:variable>
<xsl:template name="hookDefinepagemasters"/>

<!-- running heads -->
<xsl:variable name="sectionHeaders">true</xsl:variable>

<!-- page numbering -->
<xsl:variable name="formatFrontpage">i</xsl:variable>
<xsl:variable name="formatBodypage">1</xsl:variable>
<xsl:variable name="formatBackpage">1</xsl:variable>
<xsl:variable name="formatAppendix">A.1.</xsl:variable>

<!-- section headings -->
<xsl:template name="divXRefHeading">
<xsl:variable name="x">
      <xsl:apply-templates mode="section" select="head"/>
</xsl:variable>
  <xsl:text> (</xsl:text>
    <xsl:value-of select="normalize-space($x)"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<xsl:template name="setupDiv0">
 <xsl:attribute name="font-size">18pt</xsl:attribute>
 <xsl:attribute name="font-weight">bold</xsl:attribute>
 <xsl:attribute name="space-after">6pt</xsl:attribute>
 <xsl:attribute name="space-before.optimum">12pt</xsl:attribute>
 <xsl:attribute name="text-indent"><xsl:value-of select="$headingOutdent"/></xsl:attribute>
</xsl:template>

<xsl:template name="setupDiv1">
 <xsl:attribute name="font-size">14pt</xsl:attribute>
 <xsl:attribute name="font-weight">bold</xsl:attribute>
 <xsl:attribute name="space-after">3pt</xsl:attribute>
 <xsl:attribute name="space-before.optimum">9pt</xsl:attribute>
 <xsl:attribute name="text-indent"><xsl:value-of select="$headingOutdent"/></xsl:attribute>
</xsl:template>

<xsl:template name="setupDiv2">
 <xsl:attribute name="font-size">12pt</xsl:attribute>
 <xsl:attribute name="font-weight">bold</xsl:attribute>
 <xsl:attribute name="font-style">italic</xsl:attribute>
 <xsl:attribute name="space-after">2pt</xsl:attribute>
 <xsl:attribute name="space-before.optimum">4pt</xsl:attribute>
 <xsl:attribute name="text-indent"><xsl:value-of select="$headingOutdent"/></xsl:attribute>
</xsl:template>

<xsl:template name="setupDiv3">
 <xsl:attribute name="font-size">10pt</xsl:attribute>
 <xsl:attribute name="font-style">italic</xsl:attribute>
 <xsl:attribute name="space-after">0pt</xsl:attribute>
 <xsl:attribute name="space-before.optimum">4pt</xsl:attribute>
 <xsl:attribute name="text-indent"><xsl:value-of select="$headingOutdent"/></xsl:attribute>
</xsl:template>

<xsl:template name="setupDiv4">
 <xsl:attribute name="font-size">10pt</xsl:attribute>
 <xsl:attribute name="space-before.optimum">4pt</xsl:attribute>
 <xsl:attribute name="text-indent"><xsl:value-of select="$headingOutdent"/></xsl:attribute>
</xsl:template>

<!-- heading numbering -->
<xsl:variable name="numberHeadings">true</xsl:variable>
<xsl:variable name="numberDepth">9</xsl:variable>
<!-- fill in these with a valid number format (eg A.1) if needed-->
<xsl:variable name="numberBackHeadings">A.1</xsl:variable>
<xsl:variable name="numberFrontHeadings">1</xsl:variable>


<!-- pictures and graphics -->
<!-- allows for pictures in a subdirectory -->
<xsl:variable name="graphicsPrefix"></xsl:variable>
<xsl:variable name="autoScaleFigures"></xsl:variable>
<xsl:variable name="captionInlinefigures"></xsl:variable>
<xsl:variable name="figureWord">Figure </xsl:variable>
<xsl:variable name="xrefShowHead"></xsl:variable>
<xsl:variable name="xrefShowPage"></xsl:variable>
<xsl:template name="calculateFigureNumber">
     <xsl:number level="any"/>
</xsl:template>
</xsl:stylesheet>
