<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<xsl:template match="/">
 <html>
   <xsl:apply-templates/>
 </html>
</xsl:template>

<xsl:template match="TEI.2">
 <xsl:apply-templates select="text"/>
</xsl:template>

<xsl:template match="text">
  <h1>FRONT MATTER</h1>
     <xsl:apply-templates select="front"/>
  <h1>BODY MATTER</h1>
     <xsl:apply-templates select="body"/>
</xsl:template>

<xsl:template match="p">
  <p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="div">
 <h2>
  <xsl:number level="multiple" count="div"/>
  <xsl:text>. </xsl:text>
  <xsl:value-of select="head"/></h2>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="div/head">
</xsl:template>

<xsl:template match="list">
  <xsl:choose>
     <xsl:when test="@type='ordered'">
	<ol><xsl:apply-templates/></ol>
     </xsl:when>
     <xsl:when test="@type='unordered'">
	<ul><xsl:apply-templates/></ul>
     </xsl:when>
     <xsl:when test="@type='gloss'">
	<dl><xsl:apply-templates/></dl>
     </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template match="item">
  <li><xsl:apply-templates/></li>
</xsl:template>

<xsl:template match="list[@type='gloss']/item">
  <dd><xsl:apply-templates/></dd>
</xsl:template>

<xsl:template match="label">
  <dt><xsl:apply-templates/></dt>
</xsl:template>

</xsl:stylesheet>
