<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="text"/>

  <xsl:template match="/">
    <xsl:apply-templates select="//q"/>
  </xsl:template>

<xsl:template match="q">
   <xsl:call-template name="words">
     <xsl:with-param name="text">
      <xsl:value-of select="."/>
     </xsl:with-param>
   </xsl:call-template>
</xsl:template>

<xsl:template name="words">
  <xsl:param name="text"/>
<xsl:choose>
<xsl:when test="contains($text,' ')">
 <xsl:message>
  <xsl:value-of select="substring-before($text,' ')"/>
 </xsl:message>
  <xsl:call-template name="words">
     <xsl:with-param name="text">
       <xsl:value-of select="substring-after($text,' ')"/>
     </xsl:with-param>
   </xsl:call-template>
 </xsl:when>  
 <xsl:otherwise>
   <xsl:message><xsl:value-of select="$text"/></xsl:message>
 </xsl:otherwise>
</xsl:choose>
</xsl:template>
</xsl:stylesheet>
