<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="html"
 encoding="iso-8859-1" />

  <xsl:template match="/">
    <html>
      <body bgcolor="#FFFFFF">
        <h2>
          <xsl:value-of select="bncDoc/teiHeader/fileDesc/publicationStmt/idno"/>
          <xsl:text>: </xsl:text>
          <xsl:value-of select="bncDoc/teiHeader/fileDesc/titleStmt/title"/>
        </h2>
        <hr/><xsl:apply-templates select="bncDoc/teiHeader"/>
      <hr/>
        <xsl:apply-templates select="bncDoc/stext"/>
        <xsl:apply-templates select="bncDoc/text"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="teiHeader">
    <xsl:apply-templates select="profileDesc/particDesc"/>
    <xsl:apply-templates select="fileDesc/sourceDesc"/>
  </xsl:template>

  <xsl:template match="particDesc">
    <h4>Speakers in this text</h4>
    <table width="40%">
    <xsl:for-each select="person">
      <tr><td><xsl:value-of select="@id"/></td>
      <td>   
      <xsl:for-each select="*">
       <xsl:text> </xsl:text>
       <xsl:apply-templates select="."/>
      </xsl:for-each>
      </td></tr>
    </xsl:for-each>
</table>
  </xsl:template>

  <xsl:template match="sourceDesc">
    <h4>Source of text</h4>    
    <xsl:apply-templates select="recordingStmt|biblStruct"/>
  </xsl:template>

  <xsl:template match="recordingStmt">
    <p>Recordings:  
    <xsl:apply-templates select="recording"/>
</p>
  </xsl:template>

  <xsl:template match="recording">
    <xsl:number/><xsl:text>: </xsl:text>
    <xsl:if test="not(@date)">Undated</xsl:if>
    <xsl:value-of select="@date"/><xsl:text>  </xsl:text>
  </xsl:template>


  <xsl:template match="biblStruct">
    <xsl:for-each select="*">
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="."/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="title">
    <i><xsl:apply-templates/></i>
  </xsl:template>

  <!-- templates for STEXT -->

  <xsl:template match="stext/div">
    <h4>Part <xsl:number/></h4>
<h4><xsl:apply-templates select="/bncDoc/teiHeader/profileDesc/settingDesc/setting[@n='{@n}']"/>
</h4>
    <table>
    <xsl:apply-templates/>
</table>
  </xsl:template>

<xsl:template match="setting">
<h5><i><xsl:value-of select="locale"/> </i>
   <xsl:value-of select="name"/>
   <xsl:apply-templates select="activity"/>
</h5>
</xsl:template>




  <xsl:template match="stext">
    <table>
    <xsl:apply-templates/>
</table>
  </xsl:template>


  <xsl:template match="u">
    <tr><td valign="top">
<xsl:value-of select="@who"/>  
    </td>
    <td>
    <xsl:apply-templates/>
  </td></tr>
  </xsl:template>

  <xsl:template match="w|c">
    <xsl:apply-templates/>
    <!--    <sub><xsl:value-of select="@TYPE"/></sub> -->
    <!-- should do mouse-over trick -->
  </xsl:template>

  <xsl:template match="s">
    <xsl:text>[</xsl:text>
<xsl:value-of select="@n"/>  
    <xsl:text>] </xsl:text>
    <xsl:apply-templates/>
    <br/>
  </xsl:template>

  <xsl:template match="pause">
    <xsl:text> ... </xsl:text>
  </xsl:template>

  <xsl:template match="unclear">
    <xsl:text> [...] </xsl:text>
  </xsl:template>

  <xsl:template match="event">
    <xsl:text> [</xsl:text>
<xsl:value-of select="@desc"/>  
    <xsl:text>] </xsl:text>
  </xsl:template>

  <xsl:template match="vocal">
    <xsl:text> [</xsl:text>
<xsl:value-of select="@desc"/>  
    <xsl:text>] </xsl:text>
  </xsl:template>

  <xsl:template match="shift">
    <xsl:text> [</xsl:text>
<xsl:value-of select="@new"/>  
    <xsl:text>] </xsl:text>
  </xsl:template>


  <xsl:template match="text">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="p">
    <p>    <xsl:apply-templates/>
</p>
  </xsl:template>

  <xsl:template match="head">
    <h4>    <xsl:apply-templates/>
</h4>
  </xsl:template>

  <xsl:template match="pb">
    <center><h5>* * * page <xsl:value-of select="@n"/> * * *</h5></center>
  </xsl:template>

  <xsl:template match="div1|div2|div3|div4">
    <p> </p>
    <xsl:apply-templates/>
  </xsl:template>
 <xsl:template match="@*|*">
  <xsl:copy>
   <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
 </xsl:template>

</xsl:stylesheet>
