<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<xsl:output
  cdata-section-elements="eg" 
  indent="yes" 
  method="xml"
  omit-xml-declaration="no" />

<xsl:template match="*">
 <xsl:copy>
   <xsl:apply-templates select="@*"/>
   <xsl:apply-templates select="*|processing-instruction()|comment()|text()"/>
 </xsl:copy>
</xsl:template>

<xsl:template match="@*|processing-instruction()|comment()">
  <xsl:copy/>
</xsl:template>

<xsl:template match="revisionDesc">
  <xsl:element name="change">
    <date>2003-04-12</date>
    <respStmt><resp>ed</resp><name>OUCS</name></respStmt>
    <para TEIform="p">XML conversion by pretty print stylesheet</para>
  </xsl:element>
  <xsl:apply-templates/>  
</xsl:template>

<xsl:template match="s">
  <xsl:element name="s">
    <xsl:attribute name="n">
      <xsl:value-of select="./@n"/>
    </xsl:attribute>
  <xsl:apply-templates/>
</xsl:element><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="text()">
    <xsl:value-of select="."/> 
</xsl:template>

<xsl:template match="@TEIform">
  <xsl:if test="not(. = name(..))">
  <xsl:attribute name="TEIform">
    <xsl:value-of select="."/>
  </xsl:attribute>
 </xsl:if>
</xsl:template>

</xsl:stylesheet>
