/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.test;

import com.thaiopensource.datatype.xsd.regex.Regex;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Service;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.util.Utf16;
import java.io.IOException;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TestDriver
extends DefaultHandler {
    private final StringBuffer buf = new StringBuffer();
    private Regex regex;
    private int nFail = 0;
    private int nTests = 0;
    private Locator loc;
    private final RegexEngine engine;
    private static final String ERROR_MARKER = ">>>>";

    public static void main(String[] stringArray) throws SAXException, IOException, ParserConfigurationException {
        RegexEngine regexEngine;
        if (stringArray.length != 2) {
            System.err.println("usage: TestDriver class testfile");
            System.exit(2);
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        Enumeration enumeration = new Service(RegexEngine.class).getProviders();
        do {
            if (enumeration.hasMoreElements()) continue;
            System.err.println("couldn't find regex engine");
            System.exit(2);
        } while (!(regexEngine = (RegexEngine)enumeration.nextElement()).getClass().getName().equals(stringArray[0]));
        TestDriver testDriver = new TestDriver(regexEngine);
        xMLReader.setContentHandler(testDriver);
        InputSource inputSource = new InputSource(UriOrFile.fileToUri(stringArray[1]));
        xMLReader.parse(inputSource);
        System.err.println(testDriver.nTests + " tests performed");
        System.err.println(testDriver.nFail + " failures");
        if (testDriver.nFail > 0) {
            System.exit(1);
        }
    }

    public TestDriver(RegexEngine regexEngine) {
        this.engine = regexEngine;
    }

    public void setDocumentLocator(Locator locator) {
        this.loc = locator;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buf.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.buf.append(cArray, n, n2);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.buf.setLength(0);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("valid")) {
            this.valid(this.buf.toString());
        } else if (string2.equals("invalid")) {
            this.invalid(this.buf.toString());
        } else if (string2.equals("correct")) {
            this.correct(this.buf.toString());
        } else if (string2.equals("incorrect")) {
            this.incorrect(this.buf.toString());
        }
    }

    private void correct(String string) {
        ++this.nTests;
        this.regex = null;
        try {
            this.regex = this.engine.compile(string);
        }
        catch (RegexSyntaxException regexSyntaxException) {
            this.error("unexpected error: " + regexSyntaxException.getMessage() + ": " + TestDriver.display(string, regexSyntaxException.getPosition()));
        }
    }

    private void incorrect(String string) {
        ++this.nTests;
        this.regex = null;
        try {
            this.engine.compile(string);
            this.error("failed to detect error in regex: " + TestDriver.display(string, -1));
        }
        catch (RegexSyntaxException regexSyntaxException) {
            // empty catch block
        }
    }

    private void valid(String string) {
        if (this.regex == null) {
            return;
        }
        ++this.nTests;
        if (!this.regex.matches(string)) {
            this.error("match failed for string: " + TestDriver.display(string, -1));
        }
    }

    private void invalid(String string) {
        if (this.regex == null) {
            return;
        }
        ++this.nTests;
        if (this.regex.matches(string)) {
            this.error("match incorrectly succeeded for string: " + TestDriver.display(string, -1));
        }
    }

    private void error(String string) {
        int n = -1;
        if (this.loc != null) {
            n = this.loc.getLineNumber();
        }
        if (n >= 0) {
            System.err.print("Line " + n + ": ");
        }
        System.err.println(string);
        ++this.nFail;
    }

    static String display(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c;
            if (i == n) {
                stringBuffer.append(ERROR_MARKER);
            }
            if (Utf16.isSurrogate1(c = string.charAt(i))) {
                stringBuffer.append("&#x" + Integer.toHexString(Utf16.scalarValue(c, string.charAt(++i))) + ";");
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                stringBuffer.append("&#x" + Integer.toHexString(c) + ";");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c);
        }
        if (string.length() == n) {
            stringBuffer.append(ERROR_MARKER);
        }
        return stringBuffer.toString();
    }
}

